%------------------------------------------------------------------------------
% File     : ITP131^1 : TPTP v9.2.0. Released v7.5.0.
% Domain   : Interactive Theorem Proving
% Problem  : Sledgehammer Number_Partition problem prob_126__5325690_1
% Version  : Especial.
% English  :

% Refs     : [BH+15] Blanchette et al. (2015), Mining the Archive of Formal
%          : [Des21] Desharnais (2021), Email to Geoff Sutcliffe
% Source   : [Des21]
% Names    : Number_Partition/prob_126__5325690_1 [Des21]

% Status   : ContradictoryAxioms
% Rating   : 0.33 v9.1.0, 0.38 v9.0.0, 0.30 v8.2.0, 0.31 v8.1.0, 0.36 v7.5.0
% Syntax   : Number of formulae    :  225 ( 119 unt;  12 typ;   0 def)
%            Number of atoms       :  490 ( 225 equ;   0 cnn)
%            Maximal formula atoms :    4 (   2 avg)
%            Number of connectives : 1495 (  37   ~;  10   |;  20   &;1299   @)
%                                         (   0 <=>; 129  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   12 (   5 avg)
%            Number of types       :    2 (   1 usr)
%            Number of type conns  :   23 (  23   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   13 (  11 usr;   5 con; 0-2 aty)
%            Number of variables   :  519 (  13   ^; 500   !;   6   ?; 519   :)
% SPC      : TH0_CAX_EQU_NAR

% Comments : This file was generated by Sledgehammer 2021-02-23 15:42:42.866
%------------------------------------------------------------------------------
% Could-be-implicit typings (1)
thf(ty_n_t__Nat__Onat,type,
    nat: $tType ).

% Explicit typings (11)
thf(sy_c_Groups_Ominus__class_Ominus_001t__Nat__Onat,type,
    minus_minus_nat: nat > nat > nat ).

thf(sy_c_Groups_Oplus__class_Oplus_001t__Nat__Onat,type,
    plus_plus_nat: nat > nat > nat ).

thf(sy_c_Groups_Otimes__class_Otimes_001t__Nat__Onat,type,
    times_times_nat: nat > nat > nat ).

thf(sy_c_Groups_Ozero__class_Ozero_001t__Nat__Onat,type,
    zero_zero_nat: nat ).

thf(sy_c_Number__Partition__Mirabelle__zerdlymyoj_Opartitions,type,
    number1551313001itions: ( nat > nat ) > nat > $o ).

thf(sy_c_Orderings_Oord__class_Oless_001t__Nat__Onat,type,
    ord_less_nat: nat > nat > $o ).

thf(sy_c_Orderings_Oord__class_Oless__eq_001t__Nat__Onat,type,
    ord_less_eq_nat: nat > nat > $o ).

thf(sy_v_i____,type,
    i: nat ).

thf(sy_v_k,type,
    k: nat ).

thf(sy_v_n,type,
    n: nat ).

thf(sy_v_p,type,
    p: nat > nat ).

% Relevant facts (212)
thf(fact_0__092_060open_062i_A_092_060le_062_An_092_060close_062,axiom,
    ord_less_eq_nat @ i @ n ).

% \<open>i \<le> n\<close>
thf(fact_1_assms_I1_J,axiom,
    number1551313001itions @ p @ n ).

% assms(1)
thf(fact_2_upper__bound,axiom,
    ord_less_eq_nat @ ( plus_plus_nat @ ( times_times_nat @ ( p @ i ) @ i ) @ ( times_times_nat @ ( p @ k ) @ k ) ) @ n ).

% upper_bound
thf(fact_3_lower__bound,axiom,
    ord_less_nat @ n @ ( plus_plus_nat @ ( times_times_nat @ ( p @ i ) @ i ) @ ( times_times_nat @ ( p @ k ) @ k ) ) ).

% lower_bound
thf(fact_4__092_060open_062k_A_092_060le_062_An_092_060close_062,axiom,
    ord_less_eq_nat @ k @ n ).

% \<open>k \<le> n\<close>
thf(fact_5__092_060open_062p_Ai_A_092_060noteq_062_A0_092_060close_062,axiom,
    ( ( p @ i )
   != zero_zero_nat ) ).

% \<open>p i \<noteq> 0\<close>
thf(fact_6_assms_I2_J,axiom,
    ord_less_nat @ zero_zero_nat @ ( p @ k ) ).

% assms(2)
thf(fact_7__092_060open_062i_A_092_060noteq_062_Ak_092_060close_062,axiom,
    i != k ).

% \<open>i \<noteq> k\<close>
thf(fact_8__092_060open_062n_A_N_Ak_A_060_Ai_092_060close_062,axiom,
    ord_less_nat @ ( minus_minus_nat @ n @ k ) @ i ).

% \<open>n - k < i\<close>
thf(fact_9_partitions__zero,axiom,
    ! [P: nat > nat] :
      ( ( number1551313001itions @ P @ zero_zero_nat )
      = ( P
        = ( ^ [I: nat] : zero_zero_nat ) ) ) ).

% partitions_zero
thf(fact_10_partitions__bounds,axiom,
    ! [P: nat > nat,N: nat,I2: nat] :
      ( ( number1551313001itions @ P @ N )
     => ( ord_less_eq_nat @ ( P @ I2 ) @ N ) ) ).

% partitions_bounds
thf(fact_11_mult__le__cancel2,axiom,
    ! [M: nat,K: nat,N: nat] :
      ( ( ord_less_eq_nat @ ( times_times_nat @ M @ K ) @ ( times_times_nat @ N @ K ) )
      = ( ( ord_less_nat @ zero_zero_nat @ K )
       => ( ord_less_eq_nat @ M @ N ) ) ) ).

% mult_le_cancel2
thf(fact_12_nat__mult__le__cancel__disj,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ord_less_eq_nat @ ( times_times_nat @ K @ M ) @ ( times_times_nat @ K @ N ) )
      = ( ( ord_less_nat @ zero_zero_nat @ K )
       => ( ord_less_eq_nat @ M @ N ) ) ) ).

% nat_mult_le_cancel_disj
thf(fact_13_mult__less__cancel2,axiom,
    ! [M: nat,K: nat,N: nat] :
      ( ( ord_less_nat @ ( times_times_nat @ M @ K ) @ ( times_times_nat @ N @ K ) )
      = ( ( ord_less_nat @ zero_zero_nat @ K )
        & ( ord_less_nat @ M @ N ) ) ) ).

% mult_less_cancel2
thf(fact_14_nat__0__less__mult__iff,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_nat @ zero_zero_nat @ ( times_times_nat @ M @ N ) )
      = ( ( ord_less_nat @ zero_zero_nat @ M )
        & ( ord_less_nat @ zero_zero_nat @ N ) ) ) ).

% nat_0_less_mult_iff
thf(fact_15_nat__mult__less__cancel__disj,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ord_less_nat @ ( times_times_nat @ K @ M ) @ ( times_times_nat @ K @ N ) )
      = ( ( ord_less_nat @ zero_zero_nat @ K )
        & ( ord_less_nat @ M @ N ) ) ) ).

% nat_mult_less_cancel_disj
thf(fact_16_add__gr__0,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_nat @ zero_zero_nat @ ( plus_plus_nat @ M @ N ) )
      = ( ( ord_less_nat @ zero_zero_nat @ M )
        | ( ord_less_nat @ zero_zero_nat @ N ) ) ) ).

% add_gr_0
thf(fact_17_add__less__same__cancel1,axiom,
    ! [B: nat,A: nat] :
      ( ( ord_less_nat @ ( plus_plus_nat @ B @ A ) @ B )
      = ( ord_less_nat @ A @ zero_zero_nat ) ) ).

% add_less_same_cancel1
thf(fact_18_add__less__same__cancel2,axiom,
    ! [A: nat,B: nat] :
      ( ( ord_less_nat @ ( plus_plus_nat @ A @ B ) @ B )
      = ( ord_less_nat @ A @ zero_zero_nat ) ) ).

% add_less_same_cancel2
thf(fact_19_less__add__same__cancel1,axiom,
    ! [A: nat,B: nat] :
      ( ( ord_less_nat @ A @ ( plus_plus_nat @ A @ B ) )
      = ( ord_less_nat @ zero_zero_nat @ B ) ) ).

% less_add_same_cancel1
thf(fact_20_less__add__same__cancel2,axiom,
    ! [A: nat,B: nat] :
      ( ( ord_less_nat @ A @ ( plus_plus_nat @ B @ A ) )
      = ( ord_less_nat @ zero_zero_nat @ B ) ) ).

% less_add_same_cancel2
thf(fact_21_add__right__cancel,axiom,
    ! [B: nat,A: nat,C: nat] :
      ( ( ( plus_plus_nat @ B @ A )
        = ( plus_plus_nat @ C @ A ) )
      = ( B = C ) ) ).

% add_right_cancel
thf(fact_22_add__left__cancel,axiom,
    ! [A: nat,B: nat,C: nat] :
      ( ( ( plus_plus_nat @ A @ B )
        = ( plus_plus_nat @ A @ C ) )
      = ( B = C ) ) ).

% add_left_cancel
thf(fact_23_le__zero__eq,axiom,
    ! [N: nat] :
      ( ( ord_less_eq_nat @ N @ zero_zero_nat )
      = ( N = zero_zero_nat ) ) ).

% le_zero_eq
thf(fact_24_not__gr__zero,axiom,
    ! [N: nat] :
      ( ( ~ ( ord_less_nat @ zero_zero_nat @ N ) )
      = ( N = zero_zero_nat ) ) ).

% not_gr_zero
thf(fact_25_add__le__cancel__right,axiom,
    ! [A: nat,C: nat,B: nat] :
      ( ( ord_less_eq_nat @ ( plus_plus_nat @ A @ C ) @ ( plus_plus_nat @ B @ C ) )
      = ( ord_less_eq_nat @ A @ B ) ) ).

% add_le_cancel_right
thf(fact_26_add__le__cancel__left,axiom,
    ! [C: nat,A: nat,B: nat] :
      ( ( ord_less_eq_nat @ ( plus_plus_nat @ C @ A ) @ ( plus_plus_nat @ C @ B ) )
      = ( ord_less_eq_nat @ A @ B ) ) ).

% add_le_cancel_left
thf(fact_27_zero__eq__add__iff__both__eq__0,axiom,
    ! [X: nat,Y: nat] :
      ( ( zero_zero_nat
        = ( plus_plus_nat @ X @ Y ) )
      = ( ( X = zero_zero_nat )
        & ( Y = zero_zero_nat ) ) ) ).

% zero_eq_add_iff_both_eq_0
thf(fact_28_add__eq__0__iff__both__eq__0,axiom,
    ! [X: nat,Y: nat] :
      ( ( ( plus_plus_nat @ X @ Y )
        = zero_zero_nat )
      = ( ( X = zero_zero_nat )
        & ( Y = zero_zero_nat ) ) ) ).

% add_eq_0_iff_both_eq_0
thf(fact_29_add__cancel__right__right,axiom,
    ! [A: nat,B: nat] :
      ( ( A
        = ( plus_plus_nat @ A @ B ) )
      = ( B = zero_zero_nat ) ) ).

% add_cancel_right_right
thf(fact_30_add__cancel__right__left,axiom,
    ! [A: nat,B: nat] :
      ( ( A
        = ( plus_plus_nat @ B @ A ) )
      = ( B = zero_zero_nat ) ) ).

% add_cancel_right_left
thf(fact_31_add__cancel__left__right,axiom,
    ! [A: nat,B: nat] :
      ( ( ( plus_plus_nat @ A @ B )
        = A )
      = ( B = zero_zero_nat ) ) ).

% add_cancel_left_right
thf(fact_32_add__cancel__left__left,axiom,
    ! [B: nat,A: nat] :
      ( ( ( plus_plus_nat @ B @ A )
        = A )
      = ( B = zero_zero_nat ) ) ).

% add_cancel_left_left
thf(fact_33_add_Oright__neutral,axiom,
    ! [A: nat] :
      ( ( plus_plus_nat @ A @ zero_zero_nat )
      = A ) ).

% add.right_neutral
thf(fact_34_add_Oleft__neutral,axiom,
    ! [A: nat] :
      ( ( plus_plus_nat @ zero_zero_nat @ A )
      = A ) ).

% add.left_neutral
thf(fact_35_cancel__comm__monoid__add__class_Odiff__cancel,axiom,
    ! [A: nat] :
      ( ( minus_minus_nat @ A @ A )
      = zero_zero_nat ) ).

% cancel_comm_monoid_add_class.diff_cancel
thf(fact_36_diff__zero,axiom,
    ! [A: nat] :
      ( ( minus_minus_nat @ A @ zero_zero_nat )
      = A ) ).

% diff_zero
thf(fact_37_zero__diff,axiom,
    ! [A: nat] :
      ( ( minus_minus_nat @ zero_zero_nat @ A )
      = zero_zero_nat ) ).

% zero_diff
thf(fact_38_add__less__cancel__right,axiom,
    ! [A: nat,C: nat,B: nat] :
      ( ( ord_less_nat @ ( plus_plus_nat @ A @ C ) @ ( plus_plus_nat @ B @ C ) )
      = ( ord_less_nat @ A @ B ) ) ).

% add_less_cancel_right
thf(fact_39_add__less__cancel__left,axiom,
    ! [C: nat,A: nat,B: nat] :
      ( ( ord_less_nat @ ( plus_plus_nat @ C @ A ) @ ( plus_plus_nat @ C @ B ) )
      = ( ord_less_nat @ A @ B ) ) ).

% add_less_cancel_left
thf(fact_40_add__diff__cancel__right_H,axiom,
    ! [A: nat,B: nat] :
      ( ( minus_minus_nat @ ( plus_plus_nat @ A @ B ) @ B )
      = A ) ).

% add_diff_cancel_right'
thf(fact_41_add__diff__cancel__right,axiom,
    ! [A: nat,C: nat,B: nat] :
      ( ( minus_minus_nat @ ( plus_plus_nat @ A @ C ) @ ( plus_plus_nat @ B @ C ) )
      = ( minus_minus_nat @ A @ B ) ) ).

% add_diff_cancel_right
thf(fact_42_add__diff__cancel__left_H,axiom,
    ! [A: nat,B: nat] :
      ( ( minus_minus_nat @ ( plus_plus_nat @ A @ B ) @ A )
      = B ) ).

% add_diff_cancel_left'
thf(fact_43_add__diff__cancel__left,axiom,
    ! [C: nat,A: nat,B: nat] :
      ( ( minus_minus_nat @ ( plus_plus_nat @ C @ A ) @ ( plus_plus_nat @ C @ B ) )
      = ( minus_minus_nat @ A @ B ) ) ).

% add_diff_cancel_left
thf(fact_44_bot__nat__0_Onot__eq__extremum,axiom,
    ! [A: nat] :
      ( ( A != zero_zero_nat )
      = ( ord_less_nat @ zero_zero_nat @ A ) ) ).

% bot_nat_0.not_eq_extremum
thf(fact_45_less__nat__zero__code,axiom,
    ! [N: nat] :
      ~ ( ord_less_nat @ N @ zero_zero_nat ) ).

% less_nat_zero_code
thf(fact_46_neq0__conv,axiom,
    ! [N: nat] :
      ( ( N != zero_zero_nat )
      = ( ord_less_nat @ zero_zero_nat @ N ) ) ).

% neq0_conv
thf(fact_47_bot__nat__0_Oextremum,axiom,
    ! [A: nat] : ( ord_less_eq_nat @ zero_zero_nat @ A ) ).

% bot_nat_0.extremum
thf(fact_48_le0,axiom,
    ! [N: nat] : ( ord_less_eq_nat @ zero_zero_nat @ N ) ).

% le0
thf(fact_49_Nat_Oadd__0__right,axiom,
    ! [M: nat] :
      ( ( plus_plus_nat @ M @ zero_zero_nat )
      = M ) ).

% Nat.add_0_right
thf(fact_50_add__is__0,axiom,
    ! [M: nat,N: nat] :
      ( ( ( plus_plus_nat @ M @ N )
        = zero_zero_nat )
      = ( ( M = zero_zero_nat )
        & ( N = zero_zero_nat ) ) ) ).

% add_is_0
thf(fact_51_nat__add__left__cancel__less,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ord_less_nat @ ( plus_plus_nat @ K @ M ) @ ( plus_plus_nat @ K @ N ) )
      = ( ord_less_nat @ M @ N ) ) ).

% nat_add_left_cancel_less
thf(fact_52_diff__self__eq__0,axiom,
    ! [M: nat] :
      ( ( minus_minus_nat @ M @ M )
      = zero_zero_nat ) ).

% diff_self_eq_0
thf(fact_53_diff__0__eq__0,axiom,
    ! [N: nat] :
      ( ( minus_minus_nat @ zero_zero_nat @ N )
      = zero_zero_nat ) ).

% diff_0_eq_0
thf(fact_54_mult__cancel2,axiom,
    ! [M: nat,K: nat,N: nat] :
      ( ( ( times_times_nat @ M @ K )
        = ( times_times_nat @ N @ K ) )
      = ( ( M = N )
        | ( K = zero_zero_nat ) ) ) ).

% mult_cancel2
thf(fact_55_mult__cancel1,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ( times_times_nat @ K @ M )
        = ( times_times_nat @ K @ N ) )
      = ( ( M = N )
        | ( K = zero_zero_nat ) ) ) ).

% mult_cancel1
thf(fact_56_mult__0__right,axiom,
    ! [M: nat] :
      ( ( times_times_nat @ M @ zero_zero_nat )
      = zero_zero_nat ) ).

% mult_0_right
thf(fact_57_mult__is__0,axiom,
    ! [M: nat,N: nat] :
      ( ( ( times_times_nat @ M @ N )
        = zero_zero_nat )
      = ( ( M = zero_zero_nat )
        | ( N = zero_zero_nat ) ) ) ).

% mult_is_0
thf(fact_58_nat__add__left__cancel__le,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ord_less_eq_nat @ ( plus_plus_nat @ K @ M ) @ ( plus_plus_nat @ K @ N ) )
      = ( ord_less_eq_nat @ M @ N ) ) ).

% nat_add_left_cancel_le
thf(fact_59_diff__diff__cancel,axiom,
    ! [I2: nat,N: nat] :
      ( ( ord_less_eq_nat @ I2 @ N )
     => ( ( minus_minus_nat @ N @ ( minus_minus_nat @ N @ I2 ) )
        = I2 ) ) ).

% diff_diff_cancel
thf(fact_60_diff__diff__left,axiom,
    ! [I2: nat,J: nat,K: nat] :
      ( ( minus_minus_nat @ ( minus_minus_nat @ I2 @ J ) @ K )
      = ( minus_minus_nat @ I2 @ ( plus_plus_nat @ J @ K ) ) ) ).

% diff_diff_left
thf(fact_61_le__add__same__cancel2,axiom,
    ! [A: nat,B: nat] :
      ( ( ord_less_eq_nat @ A @ ( plus_plus_nat @ B @ A ) )
      = ( ord_less_eq_nat @ zero_zero_nat @ B ) ) ).

% le_add_same_cancel2
thf(fact_62_le__add__same__cancel1,axiom,
    ! [A: nat,B: nat] :
      ( ( ord_less_eq_nat @ A @ ( plus_plus_nat @ A @ B ) )
      = ( ord_less_eq_nat @ zero_zero_nat @ B ) ) ).

% le_add_same_cancel1
thf(fact_63_add__le__same__cancel2,axiom,
    ! [A: nat,B: nat] :
      ( ( ord_less_eq_nat @ ( plus_plus_nat @ A @ B ) @ B )
      = ( ord_less_eq_nat @ A @ zero_zero_nat ) ) ).

% add_le_same_cancel2
thf(fact_64_add__le__same__cancel1,axiom,
    ! [B: nat,A: nat] :
      ( ( ord_less_eq_nat @ ( plus_plus_nat @ B @ A ) @ B )
      = ( ord_less_eq_nat @ A @ zero_zero_nat ) ) ).

% add_le_same_cancel1
thf(fact_65_diff__add__zero,axiom,
    ! [A: nat,B: nat] :
      ( ( minus_minus_nat @ A @ ( plus_plus_nat @ A @ B ) )
      = zero_zero_nat ) ).

% diff_add_zero
thf(fact_66_zero__less__diff,axiom,
    ! [N: nat,M: nat] :
      ( ( ord_less_nat @ zero_zero_nat @ ( minus_minus_nat @ N @ M ) )
      = ( ord_less_nat @ M @ N ) ) ).

% zero_less_diff
thf(fact_67_diff__is__0__eq_H,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq_nat @ M @ N )
     => ( ( minus_minus_nat @ M @ N )
        = zero_zero_nat ) ) ).

% diff_is_0_eq'
thf(fact_68_diff__is__0__eq,axiom,
    ! [M: nat,N: nat] :
      ( ( ( minus_minus_nat @ M @ N )
        = zero_zero_nat )
      = ( ord_less_eq_nat @ M @ N ) ) ).

% diff_is_0_eq
thf(fact_69_Nat_Odiff__diff__right,axiom,
    ! [K: nat,J: nat,I2: nat] :
      ( ( ord_less_eq_nat @ K @ J )
     => ( ( minus_minus_nat @ I2 @ ( minus_minus_nat @ J @ K ) )
        = ( minus_minus_nat @ ( plus_plus_nat @ I2 @ K ) @ J ) ) ) ).

% Nat.diff_diff_right
thf(fact_70_Nat_Oadd__diff__assoc2,axiom,
    ! [K: nat,J: nat,I2: nat] :
      ( ( ord_less_eq_nat @ K @ J )
     => ( ( plus_plus_nat @ ( minus_minus_nat @ J @ K ) @ I2 )
        = ( minus_minus_nat @ ( plus_plus_nat @ J @ I2 ) @ K ) ) ) ).

% Nat.add_diff_assoc2
thf(fact_71_Nat_Oadd__diff__assoc,axiom,
    ! [K: nat,J: nat,I2: nat] :
      ( ( ord_less_eq_nat @ K @ J )
     => ( ( plus_plus_nat @ I2 @ ( minus_minus_nat @ J @ K ) )
        = ( minus_minus_nat @ ( plus_plus_nat @ I2 @ J ) @ K ) ) ) ).

% Nat.add_diff_assoc
thf(fact_72_cancel__ab__semigroup__add__class_Odiff__right__commute,axiom,
    ! [A: nat,C: nat,B: nat] :
      ( ( minus_minus_nat @ ( minus_minus_nat @ A @ C ) @ B )
      = ( minus_minus_nat @ ( minus_minus_nat @ A @ B ) @ C ) ) ).

% cancel_ab_semigroup_add_class.diff_right_commute
thf(fact_73_diff__commute,axiom,
    ! [I2: nat,J: nat,K: nat] :
      ( ( minus_minus_nat @ ( minus_minus_nat @ I2 @ J ) @ K )
      = ( minus_minus_nat @ ( minus_minus_nat @ I2 @ K ) @ J ) ) ).

% diff_commute
thf(fact_74_add__implies__diff,axiom,
    ! [C: nat,B: nat,A: nat] :
      ( ( ( plus_plus_nat @ C @ B )
        = A )
     => ( C
        = ( minus_minus_nat @ A @ B ) ) ) ).

% add_implies_diff
thf(fact_75_diff__diff__add,axiom,
    ! [A: nat,B: nat,C: nat] :
      ( ( minus_minus_nat @ ( minus_minus_nat @ A @ B ) @ C )
      = ( minus_minus_nat @ A @ ( plus_plus_nat @ B @ C ) ) ) ).

% diff_diff_add
thf(fact_76_minus__nat_Odiff__0,axiom,
    ! [M: nat] :
      ( ( minus_minus_nat @ M @ zero_zero_nat )
      = M ) ).

% minus_nat.diff_0
thf(fact_77_diffs0__imp__equal,axiom,
    ! [M: nat,N: nat] :
      ( ( ( minus_minus_nat @ M @ N )
        = zero_zero_nat )
     => ( ( ( minus_minus_nat @ N @ M )
          = zero_zero_nat )
       => ( M = N ) ) ) ).

% diffs0_imp_equal
thf(fact_78_less__imp__diff__less,axiom,
    ! [J: nat,K: nat,N: nat] :
      ( ( ord_less_nat @ J @ K )
     => ( ord_less_nat @ ( minus_minus_nat @ J @ N ) @ K ) ) ).

% less_imp_diff_less
thf(fact_79_diff__less__mono2,axiom,
    ! [M: nat,N: nat,L: nat] :
      ( ( ord_less_nat @ M @ N )
     => ( ( ord_less_nat @ M @ L )
       => ( ord_less_nat @ ( minus_minus_nat @ L @ N ) @ ( minus_minus_nat @ L @ M ) ) ) ) ).

% diff_less_mono2
thf(fact_80_diff__le__mono2,axiom,
    ! [M: nat,N: nat,L: nat] :
      ( ( ord_less_eq_nat @ M @ N )
     => ( ord_less_eq_nat @ ( minus_minus_nat @ L @ N ) @ ( minus_minus_nat @ L @ M ) ) ) ).

% diff_le_mono2
thf(fact_81_le__diff__iff_H,axiom,
    ! [A: nat,C: nat,B: nat] :
      ( ( ord_less_eq_nat @ A @ C )
     => ( ( ord_less_eq_nat @ B @ C )
       => ( ( ord_less_eq_nat @ ( minus_minus_nat @ C @ A ) @ ( minus_minus_nat @ C @ B ) )
          = ( ord_less_eq_nat @ B @ A ) ) ) ) ).

% le_diff_iff'
thf(fact_82_diff__le__self,axiom,
    ! [M: nat,N: nat] : ( ord_less_eq_nat @ ( minus_minus_nat @ M @ N ) @ M ) ).

% diff_le_self
thf(fact_83_diff__le__mono,axiom,
    ! [M: nat,N: nat,L: nat] :
      ( ( ord_less_eq_nat @ M @ N )
     => ( ord_less_eq_nat @ ( minus_minus_nat @ M @ L ) @ ( minus_minus_nat @ N @ L ) ) ) ).

% diff_le_mono
thf(fact_84_Nat_Odiff__diff__eq,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ord_less_eq_nat @ K @ M )
     => ( ( ord_less_eq_nat @ K @ N )
       => ( ( minus_minus_nat @ ( minus_minus_nat @ M @ K ) @ ( minus_minus_nat @ N @ K ) )
          = ( minus_minus_nat @ M @ N ) ) ) ) ).

% Nat.diff_diff_eq
thf(fact_85_le__diff__iff,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ord_less_eq_nat @ K @ M )
     => ( ( ord_less_eq_nat @ K @ N )
       => ( ( ord_less_eq_nat @ ( minus_minus_nat @ M @ K ) @ ( minus_minus_nat @ N @ K ) )
          = ( ord_less_eq_nat @ M @ N ) ) ) ) ).

% le_diff_iff
thf(fact_86_eq__diff__iff,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ord_less_eq_nat @ K @ M )
     => ( ( ord_less_eq_nat @ K @ N )
       => ( ( ( minus_minus_nat @ M @ K )
            = ( minus_minus_nat @ N @ K ) )
          = ( M = N ) ) ) ) ).

% eq_diff_iff
thf(fact_87_diff__add__inverse2,axiom,
    ! [M: nat,N: nat] :
      ( ( minus_minus_nat @ ( plus_plus_nat @ M @ N ) @ N )
      = M ) ).

% diff_add_inverse2
thf(fact_88_diff__add__inverse,axiom,
    ! [N: nat,M: nat] :
      ( ( minus_minus_nat @ ( plus_plus_nat @ N @ M ) @ N )
      = M ) ).

% diff_add_inverse
thf(fact_89_diff__cancel2,axiom,
    ! [M: nat,K: nat,N: nat] :
      ( ( minus_minus_nat @ ( plus_plus_nat @ M @ K ) @ ( plus_plus_nat @ N @ K ) )
      = ( minus_minus_nat @ M @ N ) ) ).

% diff_cancel2
thf(fact_90_Nat_Odiff__cancel,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( minus_minus_nat @ ( plus_plus_nat @ K @ M ) @ ( plus_plus_nat @ K @ N ) )
      = ( minus_minus_nat @ M @ N ) ) ).

% Nat.diff_cancel
thf(fact_91_diff__mult__distrib2,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( times_times_nat @ K @ ( minus_minus_nat @ M @ N ) )
      = ( minus_minus_nat @ ( times_times_nat @ K @ M ) @ ( times_times_nat @ K @ N ) ) ) ).

% diff_mult_distrib2
thf(fact_92_diff__mult__distrib,axiom,
    ! [M: nat,N: nat,K: nat] :
      ( ( times_times_nat @ ( minus_minus_nat @ M @ N ) @ K )
      = ( minus_minus_nat @ ( times_times_nat @ M @ K ) @ ( times_times_nat @ N @ K ) ) ) ).

% diff_mult_distrib
thf(fact_93_ordered__cancel__comm__monoid__diff__class_Ole__imp__diff__is__add,axiom,
    ! [A: nat,B: nat,C: nat] :
      ( ( ord_less_eq_nat @ A @ B )
     => ( ( ord_less_eq_nat @ A @ B )
       => ( ( ( minus_minus_nat @ B @ A )
            = C )
          = ( B
            = ( plus_plus_nat @ C @ A ) ) ) ) ) ).

% ordered_cancel_comm_monoid_diff_class.le_imp_diff_is_add
thf(fact_94_ordered__cancel__comm__monoid__diff__class_Oadd__diff__inverse,axiom,
    ! [A: nat,B: nat] :
      ( ( ord_less_eq_nat @ A @ B )
     => ( ( plus_plus_nat @ A @ ( minus_minus_nat @ B @ A ) )
        = B ) ) ).

% ordered_cancel_comm_monoid_diff_class.add_diff_inverse
thf(fact_95_ordered__cancel__comm__monoid__diff__class_Odiff__diff__right,axiom,
    ! [A: nat,B: nat,C: nat] :
      ( ( ord_less_eq_nat @ A @ B )
     => ( ( minus_minus_nat @ C @ ( minus_minus_nat @ B @ A ) )
        = ( minus_minus_nat @ ( plus_plus_nat @ C @ A ) @ B ) ) ) ).

% ordered_cancel_comm_monoid_diff_class.diff_diff_right
thf(fact_96_ordered__cancel__comm__monoid__diff__class_Odiff__add__assoc2,axiom,
    ! [A: nat,B: nat,C: nat] :
      ( ( ord_less_eq_nat @ A @ B )
     => ( ( minus_minus_nat @ ( plus_plus_nat @ B @ C ) @ A )
        = ( plus_plus_nat @ ( minus_minus_nat @ B @ A ) @ C ) ) ) ).

% ordered_cancel_comm_monoid_diff_class.diff_add_assoc2
thf(fact_97_ordered__cancel__comm__monoid__diff__class_Oadd__diff__assoc2,axiom,
    ! [A: nat,B: nat,C: nat] :
      ( ( ord_less_eq_nat @ A @ B )
     => ( ( plus_plus_nat @ ( minus_minus_nat @ B @ A ) @ C )
        = ( minus_minus_nat @ ( plus_plus_nat @ B @ C ) @ A ) ) ) ).

% ordered_cancel_comm_monoid_diff_class.add_diff_assoc2
thf(fact_98_ordered__cancel__comm__monoid__diff__class_Odiff__add__assoc,axiom,
    ! [A: nat,B: nat,C: nat] :
      ( ( ord_less_eq_nat @ A @ B )
     => ( ( minus_minus_nat @ ( plus_plus_nat @ C @ B ) @ A )
        = ( plus_plus_nat @ C @ ( minus_minus_nat @ B @ A ) ) ) ) ).

% ordered_cancel_comm_monoid_diff_class.diff_add_assoc
thf(fact_99_ordered__cancel__comm__monoid__diff__class_Oadd__diff__assoc,axiom,
    ! [A: nat,B: nat,C: nat] :
      ( ( ord_less_eq_nat @ A @ B )
     => ( ( plus_plus_nat @ C @ ( minus_minus_nat @ B @ A ) )
        = ( minus_minus_nat @ ( plus_plus_nat @ C @ B ) @ A ) ) ) ).

% ordered_cancel_comm_monoid_diff_class.add_diff_assoc
thf(fact_100_ordered__cancel__comm__monoid__diff__class_Ole__diff__conv2,axiom,
    ! [A: nat,B: nat,C: nat] :
      ( ( ord_less_eq_nat @ A @ B )
     => ( ( ord_less_eq_nat @ C @ ( minus_minus_nat @ B @ A ) )
        = ( ord_less_eq_nat @ ( plus_plus_nat @ C @ A ) @ B ) ) ) ).

% ordered_cancel_comm_monoid_diff_class.le_diff_conv2
thf(fact_101_le__add__diff,axiom,
    ! [A: nat,B: nat,C: nat] :
      ( ( ord_less_eq_nat @ A @ B )
     => ( ord_less_eq_nat @ C @ ( minus_minus_nat @ ( plus_plus_nat @ B @ C ) @ A ) ) ) ).

% le_add_diff
thf(fact_102_ordered__cancel__comm__monoid__diff__class_Odiff__add,axiom,
    ! [A: nat,B: nat] :
      ( ( ord_less_eq_nat @ A @ B )
     => ( ( plus_plus_nat @ ( minus_minus_nat @ B @ A ) @ A )
        = B ) ) ).

% ordered_cancel_comm_monoid_diff_class.diff_add
thf(fact_103_diff__less,axiom,
    ! [N: nat,M: nat] :
      ( ( ord_less_nat @ zero_zero_nat @ N )
     => ( ( ord_less_nat @ zero_zero_nat @ M )
       => ( ord_less_nat @ ( minus_minus_nat @ M @ N ) @ M ) ) ) ).

% diff_less
thf(fact_104_diff__add__0,axiom,
    ! [N: nat,M: nat] :
      ( ( minus_minus_nat @ N @ ( plus_plus_nat @ N @ M ) )
      = zero_zero_nat ) ).

% diff_add_0
thf(fact_105_diff__less__mono,axiom,
    ! [A: nat,B: nat,C: nat] :
      ( ( ord_less_nat @ A @ B )
     => ( ( ord_less_eq_nat @ C @ A )
       => ( ord_less_nat @ ( minus_minus_nat @ A @ C ) @ ( minus_minus_nat @ B @ C ) ) ) ) ).

% diff_less_mono
thf(fact_106_less__diff__iff,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ord_less_eq_nat @ K @ M )
     => ( ( ord_less_eq_nat @ K @ N )
       => ( ( ord_less_nat @ ( minus_minus_nat @ M @ K ) @ ( minus_minus_nat @ N @ K ) )
          = ( ord_less_nat @ M @ N ) ) ) ) ).

% less_diff_iff
thf(fact_107_add__diff__inverse__nat,axiom,
    ! [M: nat,N: nat] :
      ( ~ ( ord_less_nat @ M @ N )
     => ( ( plus_plus_nat @ N @ ( minus_minus_nat @ M @ N ) )
        = M ) ) ).

% add_diff_inverse_nat
thf(fact_108_less__diff__conv,axiom,
    ! [I2: nat,J: nat,K: nat] :
      ( ( ord_less_nat @ I2 @ ( minus_minus_nat @ J @ K ) )
      = ( ord_less_nat @ ( plus_plus_nat @ I2 @ K ) @ J ) ) ).

% less_diff_conv
thf(fact_109_Nat_Ole__imp__diff__is__add,axiom,
    ! [I2: nat,J: nat,K: nat] :
      ( ( ord_less_eq_nat @ I2 @ J )
     => ( ( ( minus_minus_nat @ J @ I2 )
          = K )
        = ( J
          = ( plus_plus_nat @ K @ I2 ) ) ) ) ).

% Nat.le_imp_diff_is_add
thf(fact_110_Nat_Odiff__add__assoc2,axiom,
    ! [K: nat,J: nat,I2: nat] :
      ( ( ord_less_eq_nat @ K @ J )
     => ( ( minus_minus_nat @ ( plus_plus_nat @ J @ I2 ) @ K )
        = ( plus_plus_nat @ ( minus_minus_nat @ J @ K ) @ I2 ) ) ) ).

% Nat.diff_add_assoc2
thf(fact_111_Nat_Odiff__add__assoc,axiom,
    ! [K: nat,J: nat,I2: nat] :
      ( ( ord_less_eq_nat @ K @ J )
     => ( ( minus_minus_nat @ ( plus_plus_nat @ I2 @ J ) @ K )
        = ( plus_plus_nat @ I2 @ ( minus_minus_nat @ J @ K ) ) ) ) ).

% Nat.diff_add_assoc
thf(fact_112_Nat_Ole__diff__conv2,axiom,
    ! [K: nat,J: nat,I2: nat] :
      ( ( ord_less_eq_nat @ K @ J )
     => ( ( ord_less_eq_nat @ I2 @ ( minus_minus_nat @ J @ K ) )
        = ( ord_less_eq_nat @ ( plus_plus_nat @ I2 @ K ) @ J ) ) ) ).

% Nat.le_diff_conv2
thf(fact_113_le__diff__conv,axiom,
    ! [J: nat,K: nat,I2: nat] :
      ( ( ord_less_eq_nat @ ( minus_minus_nat @ J @ K ) @ I2 )
      = ( ord_less_eq_nat @ J @ ( plus_plus_nat @ I2 @ K ) ) ) ).

% le_diff_conv
thf(fact_114_nat__diff__split__asm,axiom,
    ! [P2: nat > $o,A: nat,B: nat] :
      ( ( P2 @ ( minus_minus_nat @ A @ B ) )
      = ( ~ ( ( ( ord_less_nat @ A @ B )
              & ~ ( P2 @ zero_zero_nat ) )
            | ? [D: nat] :
                ( ( A
                  = ( plus_plus_nat @ B @ D ) )
                & ~ ( P2 @ D ) ) ) ) ) ).

% nat_diff_split_asm
thf(fact_115_nat__diff__split,axiom,
    ! [P2: nat > $o,A: nat,B: nat] :
      ( ( P2 @ ( minus_minus_nat @ A @ B ) )
      = ( ( ( ord_less_nat @ A @ B )
         => ( P2 @ zero_zero_nat ) )
        & ! [D: nat] :
            ( ( A
              = ( plus_plus_nat @ B @ D ) )
           => ( P2 @ D ) ) ) ) ).

% nat_diff_split
thf(fact_116_less__diff__conv2,axiom,
    ! [K: nat,J: nat,I2: nat] :
      ( ( ord_less_eq_nat @ K @ J )
     => ( ( ord_less_nat @ ( minus_minus_nat @ J @ K ) @ I2 )
        = ( ord_less_nat @ J @ ( plus_plus_nat @ I2 @ K ) ) ) ) ).

% less_diff_conv2
thf(fact_117_nat__diff__add__eq2,axiom,
    ! [I2: nat,J: nat,U: nat,M: nat,N: nat] :
      ( ( ord_less_eq_nat @ I2 @ J )
     => ( ( minus_minus_nat @ ( plus_plus_nat @ ( times_times_nat @ I2 @ U ) @ M ) @ ( plus_plus_nat @ ( times_times_nat @ J @ U ) @ N ) )
        = ( minus_minus_nat @ M @ ( plus_plus_nat @ ( times_times_nat @ ( minus_minus_nat @ J @ I2 ) @ U ) @ N ) ) ) ) ).

% nat_diff_add_eq2
thf(fact_118_nat__diff__add__eq1,axiom,
    ! [J: nat,I2: nat,U: nat,M: nat,N: nat] :
      ( ( ord_less_eq_nat @ J @ I2 )
     => ( ( minus_minus_nat @ ( plus_plus_nat @ ( times_times_nat @ I2 @ U ) @ M ) @ ( plus_plus_nat @ ( times_times_nat @ J @ U ) @ N ) )
        = ( minus_minus_nat @ ( plus_plus_nat @ ( times_times_nat @ ( minus_minus_nat @ I2 @ J ) @ U ) @ M ) @ N ) ) ) ).

% nat_diff_add_eq1
thf(fact_119_nat__le__add__iff2,axiom,
    ! [I2: nat,J: nat,U: nat,M: nat,N: nat] :
      ( ( ord_less_eq_nat @ I2 @ J )
     => ( ( ord_less_eq_nat @ ( plus_plus_nat @ ( times_times_nat @ I2 @ U ) @ M ) @ ( plus_plus_nat @ ( times_times_nat @ J @ U ) @ N ) )
        = ( ord_less_eq_nat @ M @ ( plus_plus_nat @ ( times_times_nat @ ( minus_minus_nat @ J @ I2 ) @ U ) @ N ) ) ) ) ).

% nat_le_add_iff2
thf(fact_120_nat__le__add__iff1,axiom,
    ! [J: nat,I2: nat,U: nat,M: nat,N: nat] :
      ( ( ord_less_eq_nat @ J @ I2 )
     => ( ( ord_less_eq_nat @ ( plus_plus_nat @ ( times_times_nat @ I2 @ U ) @ M ) @ ( plus_plus_nat @ ( times_times_nat @ J @ U ) @ N ) )
        = ( ord_less_eq_nat @ ( plus_plus_nat @ ( times_times_nat @ ( minus_minus_nat @ I2 @ J ) @ U ) @ M ) @ N ) ) ) ).

% nat_le_add_iff1
thf(fact_121_nat__eq__add__iff2,axiom,
    ! [I2: nat,J: nat,U: nat,M: nat,N: nat] :
      ( ( ord_less_eq_nat @ I2 @ J )
     => ( ( ( plus_plus_nat @ ( times_times_nat @ I2 @ U ) @ M )
          = ( plus_plus_nat @ ( times_times_nat @ J @ U ) @ N ) )
        = ( M
          = ( plus_plus_nat @ ( times_times_nat @ ( minus_minus_nat @ J @ I2 ) @ U ) @ N ) ) ) ) ).

% nat_eq_add_iff2
thf(fact_122_nat__eq__add__iff1,axiom,
    ! [J: nat,I2: nat,U: nat,M: nat,N: nat] :
      ( ( ord_less_eq_nat @ J @ I2 )
     => ( ( ( plus_plus_nat @ ( times_times_nat @ I2 @ U ) @ M )
          = ( plus_plus_nat @ ( times_times_nat @ J @ U ) @ N ) )
        = ( ( plus_plus_nat @ ( times_times_nat @ ( minus_minus_nat @ I2 @ J ) @ U ) @ M )
          = N ) ) ) ).

% nat_eq_add_iff1
thf(fact_123_nat__less__add__iff2,axiom,
    ! [I2: nat,J: nat,U: nat,M: nat,N: nat] :
      ( ( ord_less_eq_nat @ I2 @ J )
     => ( ( ord_less_nat @ ( plus_plus_nat @ ( times_times_nat @ I2 @ U ) @ M ) @ ( plus_plus_nat @ ( times_times_nat @ J @ U ) @ N ) )
        = ( ord_less_nat @ M @ ( plus_plus_nat @ ( times_times_nat @ ( minus_minus_nat @ J @ I2 ) @ U ) @ N ) ) ) ) ).

% nat_less_add_iff2
thf(fact_124_nat__less__add__iff1,axiom,
    ! [J: nat,I2: nat,U: nat,M: nat,N: nat] :
      ( ( ord_less_eq_nat @ J @ I2 )
     => ( ( ord_less_nat @ ( plus_plus_nat @ ( times_times_nat @ I2 @ U ) @ M ) @ ( plus_plus_nat @ ( times_times_nat @ J @ U ) @ N ) )
        = ( ord_less_nat @ ( plus_plus_nat @ ( times_times_nat @ ( minus_minus_nat @ I2 @ J ) @ U ) @ M ) @ N ) ) ) ).

% nat_less_add_iff1
thf(fact_125_zero__reorient,axiom,
    ! [X: nat] :
      ( ( zero_zero_nat = X )
      = ( X = zero_zero_nat ) ) ).

% zero_reorient
thf(fact_126_add__right__imp__eq,axiom,
    ! [B: nat,A: nat,C: nat] :
      ( ( ( plus_plus_nat @ B @ A )
        = ( plus_plus_nat @ C @ A ) )
     => ( B = C ) ) ).

% add_right_imp_eq
thf(fact_127_add__left__imp__eq,axiom,
    ! [A: nat,B: nat,C: nat] :
      ( ( ( plus_plus_nat @ A @ B )
        = ( plus_plus_nat @ A @ C ) )
     => ( B = C ) ) ).

% add_left_imp_eq
thf(fact_128_add_Oleft__commute,axiom,
    ! [B: nat,A: nat,C: nat] :
      ( ( plus_plus_nat @ B @ ( plus_plus_nat @ A @ C ) )
      = ( plus_plus_nat @ A @ ( plus_plus_nat @ B @ C ) ) ) ).

% add.left_commute
thf(fact_129_add_Ocommute,axiom,
    ( plus_plus_nat
    = ( ^ [A2: nat,B2: nat] : ( plus_plus_nat @ B2 @ A2 ) ) ) ).

% add.commute
thf(fact_130_add_Oassoc,axiom,
    ! [A: nat,B: nat,C: nat] :
      ( ( plus_plus_nat @ ( plus_plus_nat @ A @ B ) @ C )
      = ( plus_plus_nat @ A @ ( plus_plus_nat @ B @ C ) ) ) ).

% add.assoc
thf(fact_131_group__cancel_Oadd2,axiom,
    ! [B3: nat,K: nat,B: nat,A: nat] :
      ( ( B3
        = ( plus_plus_nat @ K @ B ) )
     => ( ( plus_plus_nat @ A @ B3 )
        = ( plus_plus_nat @ K @ ( plus_plus_nat @ A @ B ) ) ) ) ).

% group_cancel.add2
thf(fact_132_group__cancel_Oadd1,axiom,
    ! [A3: nat,K: nat,A: nat,B: nat] :
      ( ( A3
        = ( plus_plus_nat @ K @ A ) )
     => ( ( plus_plus_nat @ A3 @ B )
        = ( plus_plus_nat @ K @ ( plus_plus_nat @ A @ B ) ) ) ) ).

% group_cancel.add1
thf(fact_133_add__mono__thms__linordered__semiring_I4_J,axiom,
    ! [I2: nat,J: nat,K: nat,L: nat] :
      ( ( ( I2 = J )
        & ( K = L ) )
     => ( ( plus_plus_nat @ I2 @ K )
        = ( plus_plus_nat @ J @ L ) ) ) ).

% add_mono_thms_linordered_semiring(4)
thf(fact_134_ab__semigroup__add__class_Oadd__ac_I1_J,axiom,
    ! [A: nat,B: nat,C: nat] :
      ( ( plus_plus_nat @ ( plus_plus_nat @ A @ B ) @ C )
      = ( plus_plus_nat @ A @ ( plus_plus_nat @ B @ C ) ) ) ).

% ab_semigroup_add_class.add_ac(1)
thf(fact_135_mult_Oleft__commute,axiom,
    ! [B: nat,A: nat,C: nat] :
      ( ( times_times_nat @ B @ ( times_times_nat @ A @ C ) )
      = ( times_times_nat @ A @ ( times_times_nat @ B @ C ) ) ) ).

% mult.left_commute
thf(fact_136_mult_Ocommute,axiom,
    ( times_times_nat
    = ( ^ [A2: nat,B2: nat] : ( times_times_nat @ B2 @ A2 ) ) ) ).

% mult.commute
thf(fact_137_mult_Oassoc,axiom,
    ! [A: nat,B: nat,C: nat] :
      ( ( times_times_nat @ ( times_times_nat @ A @ B ) @ C )
      = ( times_times_nat @ A @ ( times_times_nat @ B @ C ) ) ) ).

% mult.assoc
thf(fact_138_ab__semigroup__mult__class_Omult__ac_I1_J,axiom,
    ! [A: nat,B: nat,C: nat] :
      ( ( times_times_nat @ ( times_times_nat @ A @ B ) @ C )
      = ( times_times_nat @ A @ ( times_times_nat @ B @ C ) ) ) ).

% ab_semigroup_mult_class.mult_ac(1)
thf(fact_139_linorder__neqE__nat,axiom,
    ! [X: nat,Y: nat] :
      ( ( X != Y )
     => ( ~ ( ord_less_nat @ X @ Y )
       => ( ord_less_nat @ Y @ X ) ) ) ).

% linorder_neqE_nat
thf(fact_140_infinite__descent,axiom,
    ! [P2: nat > $o,N: nat] :
      ( ! [N2: nat] :
          ( ~ ( P2 @ N2 )
         => ? [M2: nat] :
              ( ( ord_less_nat @ M2 @ N2 )
              & ~ ( P2 @ M2 ) ) )
     => ( P2 @ N ) ) ).

% infinite_descent
thf(fact_141_nat__less__induct,axiom,
    ! [P2: nat > $o,N: nat] :
      ( ! [N2: nat] :
          ( ! [M2: nat] :
              ( ( ord_less_nat @ M2 @ N2 )
             => ( P2 @ M2 ) )
         => ( P2 @ N2 ) )
     => ( P2 @ N ) ) ).

% nat_less_induct
thf(fact_142_less__irrefl__nat,axiom,
    ! [N: nat] :
      ~ ( ord_less_nat @ N @ N ) ).

% less_irrefl_nat
thf(fact_143_less__not__refl3,axiom,
    ! [S: nat,T: nat] :
      ( ( ord_less_nat @ S @ T )
     => ( S != T ) ) ).

% less_not_refl3
thf(fact_144_less__not__refl2,axiom,
    ! [N: nat,M: nat] :
      ( ( ord_less_nat @ N @ M )
     => ( M != N ) ) ).

% less_not_refl2
thf(fact_145_less__not__refl,axiom,
    ! [N: nat] :
      ~ ( ord_less_nat @ N @ N ) ).

% less_not_refl
thf(fact_146_nat__neq__iff,axiom,
    ! [M: nat,N: nat] :
      ( ( M != N )
      = ( ( ord_less_nat @ M @ N )
        | ( ord_less_nat @ N @ M ) ) ) ).

% nat_neq_iff
thf(fact_147_Nat_Oex__has__greatest__nat,axiom,
    ! [P2: nat > $o,K: nat,B: nat] :
      ( ( P2 @ K )
     => ( ! [Y2: nat] :
            ( ( P2 @ Y2 )
           => ( ord_less_eq_nat @ Y2 @ B ) )
       => ? [X2: nat] :
            ( ( P2 @ X2 )
            & ! [Y3: nat] :
                ( ( P2 @ Y3 )
               => ( ord_less_eq_nat @ Y3 @ X2 ) ) ) ) ) ).

% Nat.ex_has_greatest_nat
thf(fact_148_nat__le__linear,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq_nat @ M @ N )
      | ( ord_less_eq_nat @ N @ M ) ) ).

% nat_le_linear
thf(fact_149_le__antisym,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq_nat @ M @ N )
     => ( ( ord_less_eq_nat @ N @ M )
       => ( M = N ) ) ) ).

% le_antisym
thf(fact_150_eq__imp__le,axiom,
    ! [M: nat,N: nat] :
      ( ( M = N )
     => ( ord_less_eq_nat @ M @ N ) ) ).

% eq_imp_le
thf(fact_151_le__trans,axiom,
    ! [I2: nat,J: nat,K: nat] :
      ( ( ord_less_eq_nat @ I2 @ J )
     => ( ( ord_less_eq_nat @ J @ K )
       => ( ord_less_eq_nat @ I2 @ K ) ) ) ).

% le_trans
thf(fact_152_le__refl,axiom,
    ! [N: nat] : ( ord_less_eq_nat @ N @ N ) ).

% le_refl
thf(fact_153_zero__le,axiom,
    ! [X: nat] : ( ord_less_eq_nat @ zero_zero_nat @ X ) ).

% zero_le
thf(fact_154_zero__less__iff__neq__zero,axiom,
    ! [N: nat] :
      ( ( ord_less_nat @ zero_zero_nat @ N )
      = ( N != zero_zero_nat ) ) ).

% zero_less_iff_neq_zero
thf(fact_155_gr__implies__not__zero,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_nat @ M @ N )
     => ( N != zero_zero_nat ) ) ).

% gr_implies_not_zero
thf(fact_156_not__less__zero,axiom,
    ! [N: nat] :
      ~ ( ord_less_nat @ N @ zero_zero_nat ) ).

% not_less_zero
thf(fact_157_gr__zeroI,axiom,
    ! [N: nat] :
      ( ( N != zero_zero_nat )
     => ( ord_less_nat @ zero_zero_nat @ N ) ) ).

% gr_zeroI
thf(fact_158_add__le__imp__le__right,axiom,
    ! [A: nat,C: nat,B: nat] :
      ( ( ord_less_eq_nat @ ( plus_plus_nat @ A @ C ) @ ( plus_plus_nat @ B @ C ) )
     => ( ord_less_eq_nat @ A @ B ) ) ).

% add_le_imp_le_right
thf(fact_159_add__le__imp__le__left,axiom,
    ! [C: nat,A: nat,B: nat] :
      ( ( ord_less_eq_nat @ ( plus_plus_nat @ C @ A ) @ ( plus_plus_nat @ C @ B ) )
     => ( ord_less_eq_nat @ A @ B ) ) ).

% add_le_imp_le_left
thf(fact_160_le__iff__add,axiom,
    ( ord_less_eq_nat
    = ( ^ [A2: nat,B2: nat] :
        ? [C2: nat] :
          ( B2
          = ( plus_plus_nat @ A2 @ C2 ) ) ) ) ).

% le_iff_add
thf(fact_161_add__right__mono,axiom,
    ! [A: nat,B: nat,C: nat] :
      ( ( ord_less_eq_nat @ A @ B )
     => ( ord_less_eq_nat @ ( plus_plus_nat @ A @ C ) @ ( plus_plus_nat @ B @ C ) ) ) ).

% add_right_mono
thf(fact_162_less__eqE,axiom,
    ! [A: nat,B: nat] :
      ( ( ord_less_eq_nat @ A @ B )
     => ~ ! [C3: nat] :
            ( B
           != ( plus_plus_nat @ A @ C3 ) ) ) ).

% less_eqE
thf(fact_163_add__left__mono,axiom,
    ! [A: nat,B: nat,C: nat] :
      ( ( ord_less_eq_nat @ A @ B )
     => ( ord_less_eq_nat @ ( plus_plus_nat @ C @ A ) @ ( plus_plus_nat @ C @ B ) ) ) ).

% add_left_mono
thf(fact_164_add__mono,axiom,
    ! [A: nat,B: nat,C: nat,D2: nat] :
      ( ( ord_less_eq_nat @ A @ B )
     => ( ( ord_less_eq_nat @ C @ D2 )
       => ( ord_less_eq_nat @ ( plus_plus_nat @ A @ C ) @ ( plus_plus_nat @ B @ D2 ) ) ) ) ).

% add_mono
thf(fact_165_add__mono__thms__linordered__semiring_I1_J,axiom,
    ! [I2: nat,J: nat,K: nat,L: nat] :
      ( ( ( ord_less_eq_nat @ I2 @ J )
        & ( ord_less_eq_nat @ K @ L ) )
     => ( ord_less_eq_nat @ ( plus_plus_nat @ I2 @ K ) @ ( plus_plus_nat @ J @ L ) ) ) ).

% add_mono_thms_linordered_semiring(1)
thf(fact_166_add__mono__thms__linordered__semiring_I2_J,axiom,
    ! [I2: nat,J: nat,K: nat,L: nat] :
      ( ( ( I2 = J )
        & ( ord_less_eq_nat @ K @ L ) )
     => ( ord_less_eq_nat @ ( plus_plus_nat @ I2 @ K ) @ ( plus_plus_nat @ J @ L ) ) ) ).

% add_mono_thms_linordered_semiring(2)
thf(fact_167_add__mono__thms__linordered__semiring_I3_J,axiom,
    ! [I2: nat,J: nat,K: nat,L: nat] :
      ( ( ( ord_less_eq_nat @ I2 @ J )
        & ( K = L ) )
     => ( ord_less_eq_nat @ ( plus_plus_nat @ I2 @ K ) @ ( plus_plus_nat @ J @ L ) ) ) ).

% add_mono_thms_linordered_semiring(3)
thf(fact_168_add_Ocomm__neutral,axiom,
    ! [A: nat] :
      ( ( plus_plus_nat @ A @ zero_zero_nat )
      = A ) ).

% add.comm_neutral
thf(fact_169_comm__monoid__add__class_Oadd__0,axiom,
    ! [A: nat] :
      ( ( plus_plus_nat @ zero_zero_nat @ A )
      = A ) ).

% comm_monoid_add_class.add_0
thf(fact_170_add__less__imp__less__right,axiom,
    ! [A: nat,C: nat,B: nat] :
      ( ( ord_less_nat @ ( plus_plus_nat @ A @ C ) @ ( plus_plus_nat @ B @ C ) )
     => ( ord_less_nat @ A @ B ) ) ).

% add_less_imp_less_right
thf(fact_171_add__less__imp__less__left,axiom,
    ! [C: nat,A: nat,B: nat] :
      ( ( ord_less_nat @ ( plus_plus_nat @ C @ A ) @ ( plus_plus_nat @ C @ B ) )
     => ( ord_less_nat @ A @ B ) ) ).

% add_less_imp_less_left
thf(fact_172_add__strict__right__mono,axiom,
    ! [A: nat,B: nat,C: nat] :
      ( ( ord_less_nat @ A @ B )
     => ( ord_less_nat @ ( plus_plus_nat @ A @ C ) @ ( plus_plus_nat @ B @ C ) ) ) ).

% add_strict_right_mono
thf(fact_173_add__strict__left__mono,axiom,
    ! [A: nat,B: nat,C: nat] :
      ( ( ord_less_nat @ A @ B )
     => ( ord_less_nat @ ( plus_plus_nat @ C @ A ) @ ( plus_plus_nat @ C @ B ) ) ) ).

% add_strict_left_mono
thf(fact_174_add__strict__mono,axiom,
    ! [A: nat,B: nat,C: nat,D2: nat] :
      ( ( ord_less_nat @ A @ B )
     => ( ( ord_less_nat @ C @ D2 )
       => ( ord_less_nat @ ( plus_plus_nat @ A @ C ) @ ( plus_plus_nat @ B @ D2 ) ) ) ) ).

% add_strict_mono
thf(fact_175_add__mono__thms__linordered__field_I1_J,axiom,
    ! [I2: nat,J: nat,K: nat,L: nat] :
      ( ( ( ord_less_nat @ I2 @ J )
        & ( K = L ) )
     => ( ord_less_nat @ ( plus_plus_nat @ I2 @ K ) @ ( plus_plus_nat @ J @ L ) ) ) ).

% add_mono_thms_linordered_field(1)
thf(fact_176_add__mono__thms__linordered__field_I2_J,axiom,
    ! [I2: nat,J: nat,K: nat,L: nat] :
      ( ( ( I2 = J )
        & ( ord_less_nat @ K @ L ) )
     => ( ord_less_nat @ ( plus_plus_nat @ I2 @ K ) @ ( plus_plus_nat @ J @ L ) ) ) ).

% add_mono_thms_linordered_field(2)
thf(fact_177_add__mono__thms__linordered__field_I5_J,axiom,
    ! [I2: nat,J: nat,K: nat,L: nat] :
      ( ( ( ord_less_nat @ I2 @ J )
        & ( ord_less_nat @ K @ L ) )
     => ( ord_less_nat @ ( plus_plus_nat @ I2 @ K ) @ ( plus_plus_nat @ J @ L ) ) ) ).

% add_mono_thms_linordered_field(5)
thf(fact_178_bot__nat__0_Oextremum__strict,axiom,
    ! [A: nat] :
      ~ ( ord_less_nat @ A @ zero_zero_nat ) ).

% bot_nat_0.extremum_strict
thf(fact_179_infinite__descent0,axiom,
    ! [P2: nat > $o,N: nat] :
      ( ( P2 @ zero_zero_nat )
     => ( ! [N2: nat] :
            ( ( ord_less_nat @ zero_zero_nat @ N2 )
           => ( ~ ( P2 @ N2 )
             => ? [M2: nat] :
                  ( ( ord_less_nat @ M2 @ N2 )
                  & ~ ( P2 @ M2 ) ) ) )
       => ( P2 @ N ) ) ) ).

% infinite_descent0
thf(fact_180_gr__implies__not0,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_nat @ M @ N )
     => ( N != zero_zero_nat ) ) ).

% gr_implies_not0
thf(fact_181_less__zeroE,axiom,
    ! [N: nat] :
      ~ ( ord_less_nat @ N @ zero_zero_nat ) ).

% less_zeroE
thf(fact_182_not__less0,axiom,
    ! [N: nat] :
      ~ ( ord_less_nat @ N @ zero_zero_nat ) ).

% not_less0
thf(fact_183_not__gr0,axiom,
    ! [N: nat] :
      ( ( ~ ( ord_less_nat @ zero_zero_nat @ N ) )
      = ( N = zero_zero_nat ) ) ).

% not_gr0
thf(fact_184_gr0I,axiom,
    ! [N: nat] :
      ( ( N != zero_zero_nat )
     => ( ord_less_nat @ zero_zero_nat @ N ) ) ).

% gr0I
thf(fact_185_bot__nat__0_Oextremum__uniqueI,axiom,
    ! [A: nat] :
      ( ( ord_less_eq_nat @ A @ zero_zero_nat )
     => ( A = zero_zero_nat ) ) ).

% bot_nat_0.extremum_uniqueI
thf(fact_186_bot__nat__0_Oextremum__unique,axiom,
    ! [A: nat] :
      ( ( ord_less_eq_nat @ A @ zero_zero_nat )
      = ( A = zero_zero_nat ) ) ).

% bot_nat_0.extremum_unique
thf(fact_187_le__0__eq,axiom,
    ! [N: nat] :
      ( ( ord_less_eq_nat @ N @ zero_zero_nat )
      = ( N = zero_zero_nat ) ) ).

% le_0_eq
thf(fact_188_less__eq__nat_Osimps_I1_J,axiom,
    ! [N: nat] : ( ord_less_eq_nat @ zero_zero_nat @ N ) ).

% less_eq_nat.simps(1)
thf(fact_189_add__eq__self__zero,axiom,
    ! [M: nat,N: nat] :
      ( ( ( plus_plus_nat @ M @ N )
        = M )
     => ( N = zero_zero_nat ) ) ).

% add_eq_self_zero
thf(fact_190_plus__nat_Oadd__0,axiom,
    ! [N: nat] :
      ( ( plus_plus_nat @ zero_zero_nat @ N )
      = N ) ).

% plus_nat.add_0
thf(fact_191_less__mono__imp__le__mono,axiom,
    ! [F: nat > nat,I2: nat,J: nat] :
      ( ! [I3: nat,J2: nat] :
          ( ( ord_less_nat @ I3 @ J2 )
         => ( ord_less_nat @ ( F @ I3 ) @ ( F @ J2 ) ) )
     => ( ( ord_less_eq_nat @ I2 @ J )
       => ( ord_less_eq_nat @ ( F @ I2 ) @ ( F @ J ) ) ) ) ).

% less_mono_imp_le_mono
thf(fact_192_le__neq__implies__less,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_eq_nat @ M @ N )
     => ( ( M != N )
       => ( ord_less_nat @ M @ N ) ) ) ).

% le_neq_implies_less
thf(fact_193_less__or__eq__imp__le,axiom,
    ! [M: nat,N: nat] :
      ( ( ( ord_less_nat @ M @ N )
        | ( M = N ) )
     => ( ord_less_eq_nat @ M @ N ) ) ).

% less_or_eq_imp_le
thf(fact_194_le__eq__less__or__eq,axiom,
    ( ord_less_eq_nat
    = ( ^ [M3: nat,N3: nat] :
          ( ( ord_less_nat @ M3 @ N3 )
          | ( M3 = N3 ) ) ) ) ).

% le_eq_less_or_eq
thf(fact_195_less__imp__le__nat,axiom,
    ! [M: nat,N: nat] :
      ( ( ord_less_nat @ M @ N )
     => ( ord_less_eq_nat @ M @ N ) ) ).

% less_imp_le_nat
thf(fact_196_nat__less__le,axiom,
    ( ord_less_nat
    = ( ^ [M3: nat,N3: nat] :
          ( ( ord_less_eq_nat @ M3 @ N3 )
          & ( M3 != N3 ) ) ) ) ).

% nat_less_le
thf(fact_197_less__add__eq__less,axiom,
    ! [K: nat,L: nat,M: nat,N: nat] :
      ( ( ord_less_nat @ K @ L )
     => ( ( ( plus_plus_nat @ M @ L )
          = ( plus_plus_nat @ K @ N ) )
       => ( ord_less_nat @ M @ N ) ) ) ).

% less_add_eq_less
thf(fact_198_trans__less__add2,axiom,
    ! [I2: nat,J: nat,M: nat] :
      ( ( ord_less_nat @ I2 @ J )
     => ( ord_less_nat @ I2 @ ( plus_plus_nat @ M @ J ) ) ) ).

% trans_less_add2
thf(fact_199_trans__less__add1,axiom,
    ! [I2: nat,J: nat,M: nat] :
      ( ( ord_less_nat @ I2 @ J )
     => ( ord_less_nat @ I2 @ ( plus_plus_nat @ J @ M ) ) ) ).

% trans_less_add1
thf(fact_200_add__less__mono1,axiom,
    ! [I2: nat,J: nat,K: nat] :
      ( ( ord_less_nat @ I2 @ J )
     => ( ord_less_nat @ ( plus_plus_nat @ I2 @ K ) @ ( plus_plus_nat @ J @ K ) ) ) ).

% add_less_mono1
thf(fact_201_not__add__less2,axiom,
    ! [J: nat,I2: nat] :
      ~ ( ord_less_nat @ ( plus_plus_nat @ J @ I2 ) @ I2 ) ).

% not_add_less2
thf(fact_202_not__add__less1,axiom,
    ! [I2: nat,J: nat] :
      ~ ( ord_less_nat @ ( plus_plus_nat @ I2 @ J ) @ I2 ) ).

% not_add_less1
thf(fact_203_add__less__mono,axiom,
    ! [I2: nat,J: nat,K: nat,L: nat] :
      ( ( ord_less_nat @ I2 @ J )
     => ( ( ord_less_nat @ K @ L )
       => ( ord_less_nat @ ( plus_plus_nat @ I2 @ K ) @ ( plus_plus_nat @ J @ L ) ) ) ) ).

% add_less_mono
thf(fact_204_add__lessD1,axiom,
    ! [I2: nat,J: nat,K: nat] :
      ( ( ord_less_nat @ ( plus_plus_nat @ I2 @ J ) @ K )
     => ( ord_less_nat @ I2 @ K ) ) ).

% add_lessD1
thf(fact_205_nat__mult__eq__cancel__disj,axiom,
    ! [K: nat,M: nat,N: nat] :
      ( ( ( times_times_nat @ K @ M )
        = ( times_times_nat @ K @ N ) )
      = ( ( K = zero_zero_nat )
        | ( M = N ) ) ) ).

% nat_mult_eq_cancel_disj
thf(fact_206_mult__0,axiom,
    ! [N: nat] :
      ( ( times_times_nat @ zero_zero_nat @ N )
      = zero_zero_nat ) ).

% mult_0
thf(fact_207_nat__le__iff__add,axiom,
    ( ord_less_eq_nat
    = ( ^ [M3: nat,N3: nat] :
        ? [K2: nat] :
          ( N3
          = ( plus_plus_nat @ M3 @ K2 ) ) ) ) ).

% nat_le_iff_add
thf(fact_208_trans__le__add2,axiom,
    ! [I2: nat,J: nat,M: nat] :
      ( ( ord_less_eq_nat @ I2 @ J )
     => ( ord_less_eq_nat @ I2 @ ( plus_plus_nat @ M @ J ) ) ) ).

% trans_le_add2
thf(fact_209_trans__le__add1,axiom,
    ! [I2: nat,J: nat,M: nat] :
      ( ( ord_less_eq_nat @ I2 @ J )
     => ( ord_less_eq_nat @ I2 @ ( plus_plus_nat @ J @ M ) ) ) ).

% trans_le_add1
thf(fact_210_add__le__mono1,axiom,
    ! [I2: nat,J: nat,K: nat] :
      ( ( ord_less_eq_nat @ I2 @ J )
     => ( ord_less_eq_nat @ ( plus_plus_nat @ I2 @ K ) @ ( plus_plus_nat @ J @ K ) ) ) ).

% add_le_mono1
thf(fact_211_add__le__mono,axiom,
    ! [I2: nat,J: nat,K: nat,L: nat] :
      ( ( ord_less_eq_nat @ I2 @ J )
     => ( ( ord_less_eq_nat @ K @ L )
       => ( ord_less_eq_nat @ ( plus_plus_nat @ I2 @ K ) @ ( plus_plus_nat @ J @ L ) ) ) ) ).

% add_le_mono

% Conjectures (1)
thf(conj_0,conjecture,
    $false ).

%------------------------------------------------------------------------------
